// Jūsu spēles inicializācijas skripts vai objektā
load_leaderboard();

// Inicializē globālās mainīgās
if (!variable_global_exists("fullscreen_enabled")) global.fullscreen_enabled = false;

// Inicializē globālo mainīgo leaderboard
if (!variable_global_exists("leaderboard")) {
    global.leaderboard = ds_list_create();
}

// oTitle_Menu Create notikums
powerUps = [
    { name: "Jump Boost", icon: sJumpBoostIcon, effect: function() { global.jspd[0] = -10; } },
    { name: "Double Speed", icon: sDoubleSpeedIcon, effect: function() { global.moveSpd *= 2; } },
    { name: "Bounce Boost", icon: sBounceBoostIcon, effect: function() { global.bounceBack = 1.2; } },
    { name: "Dash", icon: sDashIcon, effect: function() { global.canDash = true; } },
    // Šeit pievienojiet vairāk uzlabojumus
];


// Menedžmenta uzstādīšana
width = 64;
height = 104;

last_selected = 0;

op_border = 8;
op_space = 16;

pos = 0;

// Galvenās izvēlnes opcijas
option[0] = ["New Game", "Load Game", "Settings", "Leaderboard", "Quit Game"];

// Uzstādījumu izvēlnes opcijas
option[1] = ["Window Size", "Controls", "Objective", "Back"];

// Loga izmēra apakšizvēlne
option[2] = ["Window Size: 1x", "Window mode: Fullscreen", "Back"];

// Vadības apakšizvēlne
option[5] = [
    "Move Left: Left Arrow / A",
    "Move Right: Right Arrow / D",
    "Jump: Spacebar",
    "Dash: Shift",
    "Select: Enter",
    "Pause: P",
    "Back"
];

// Mērķa apakšizvēlne
option[4] = ["The objective of the game is to beat it as fast as possible.", "Back"];

// Rezultātu tabulas izvēlne
option[3] = [];
if (ds_list_size(global.leaderboard) == 0) {
    array_push(option[3], "No entries yet");
} else {
    for (var i = 0; i < ds_list_size(global.leaderboard); i++) {
        var entry = ds_list_find_value(global.leaderboard, i); // Iegūt masīvu
        var player_name = entry[0];
        var elapsed_time = entry[1];
        array_push(option[3], string(i + 1) + ". " + player_name + " - " + string_format(elapsed_time, 0, 2) + " s");
    }
}
array_push(option[3], "Back to Main Menu"); // Pievieno atpakaļ opciju apakšā


// Vārda ievades apakšizvēlne
option[6] = ["Enter your name: ", "Accept", "Back"];

// Inicializēt izvēlnes līmeni
menu_level = 0; // Sākt no galvenās izvēlnes

// Mainīgie vārda ievadei
global.player_name = ""; // Noklusējuma vārds
name_input_active = false; // Vai vārda ievade šobrīd ir aktīva

// Funkcija, lai atiestatītu spēles stāvokli
function reset_game() {
    global.elapsed_time = 0;
    global.powerUps = [];
    global.collected_orbs = ds_list_create();

    // Pārliecinieties, ka uzlabojumu efekti ir atiestatīti
    global.jspd = [-7.15, -1.15]; // Noklusējuma lēciena ātrumi
    global.moveSpd = 0.5;   // Noklusējuma pārvietošanās ātrums
    global.bounceBack = 0.4; // Noklusējuma atlecošā atgriešana
    global.canDash = false;  // Noklusējuma strēles spēja
}

function calculate_menu_size() {
    width = 0;
    for (var i = 0; i < array_length(option[menu_level]); i++) {
        var _op_w = string_width(option[menu_level][i]);
        width = max(width, _op_w);
    }

    if (menu_level == 6) { // Pārbaudiet, vai tā ir vārda ievades apakšizvēlne
        width += 100; // Palieliniet platumu īpaši šai apakšizvēlnei
    } else {
        width += op_border * 2;
    }

    if (array_length(option[menu_level]) > 0) {
        height = op_border * 2 + string_height(option[menu_level][0]) + (array_length(option[menu_level]) - 1) * op_space;
    } else {
        height = op_border  * 2; // Noklusējuma augstums tukšām izvēlnēm
    }
}

// Inicializējiet izvēlnes izmērus
calculate_menu_size();
